// Security_DemoDlg.h : header file
//

#if !defined(AFX_SECURITY_DEMODLG_H__92E42A9E_9293_4DF1_B69F_F64D383EDAF0__INCLUDED_)
#define AFX_SECURITY_DEMODLG_H__92E42A9E_9293_4DF1_B69F_F64D383EDAF0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MyViewManager.h"

#include "MyVideoWnd.h"

typedef struct _MY_SCF_FILE_INFO
{
	double			dFileStartTime;
	
	double			dFileStopTime;

	double			dVideoStartTime;
	
	double			dVideoStopTime;

	ULONG			m_nVideoEncoderFormat;

	ULONG			m_nAudioEncoderFormat;

	ULONG			m_nVideoWidth;
	 
	ULONG			m_nVideoHeight;
	
	double			m_dVideoFrameRate;
	
	ULONG			m_nAudioChannels;
	
	ULONG			m_nAudioBitsPerSample;
	
	ULONG			m_nAudioSampleFrequency;	

	ULONG			m_dTotalVideoFrames;

	ULONG			m_dTotalAudioFrames;

	double			m_dTotalDurationTimes;

} MY_SCF_FILE_INFO;

/////////////////////////////////////////////////////////////////////////////
// CSecurity_DemoDlg dialog

class CSecurity_DemoDlg : public CDialog
{
// Construction
public:
	CSecurity_DemoDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSecurity_DemoDlg)
	enum { IDD = IDD_SECURITY_DEMO_DIALOG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSecurity_DemoDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CSecurity_DemoDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnDestroy();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:	

	ULONG								m_nRecordCout[ MAX_NUM_CHANNELS ];

	vector<MY_SCF_FILE_INFO>			m_vs_file_info[ MAX_NUM_CHANNELS ];

	PVOID								m_pScfFile[ MAX_NUM_CHANNELS ];
	
	MyViewManager  *					m_pViewManager;

	MyVideoWnd							m_oVideoWnd[ 64 ];

	CMenu								m_PopupMenu;

	CShowInfoDlg						m_ShowInfoDlg;	

public:	

	CString GetWorkingPath(CString strWorkFile);	

	BOOL IsFileExists(const TCHAR* pFile);	

	void GetFileInfoList( ULONG nCH, double dStartSearchSystemTime, double dStopSearchSystemTime );

	void OpenScfFile( ULONG nCH );

	void SetScfFileGlobalTimer( ULONG nCH );
			
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SECURITY_DEMODLG_H__92E42A9E_9293_4DF1_B69F_F64D383EDAF0__INCLUDED_)
